---------------------------------------------------------------------------------------------------
--
-- Title        : RAM Controll
-- Design       : VGA Example
-- Author       : Stanislaw Dabek
-- Company      : ALTIUM
-- DATA         : 25-09-2003
-- Version      : 1.00.A01
--
---------------------------------------------------------------------------------------------------
--
-- Description :
---------------------------------------------------------------------------------------------------

library IEEE;
    use IEEE.std_logic_1164.all;

entity RAM_Controll is
    port
    (
        DISP_RD         : in    std_logic;
        C51_RD          : in    std_logic;
        C51_WR          : in    std_logic;
        C51_ADDRESS     : in    std_logic_vector(16 downto 0);
        DISP_ADDRESS    : in    std_logic_vector(16 downto 0);
        C51_DATAI       : in    std_logic_vector(7 downto 0);
        ADDRESSO        : out   std_logic_vector(16 downto 0);
        RDO             : out   std_logic;
        C51_DATAO       : out   std_logic_vector(7 downto 0);
        DISP_DATAO      : out   std_logic_vector(7 downto 0);
        RAM_DATAIO      : inout std_logic_vector(7 downto 0);
        RAMWRP          : out   STD_LOGIC;
        RAMWR           : out   STD_LOGIC
        
    );
end RAM_Controll;

architecture RAM_Controll_Arch of RAM_Controll is

    ---- Signal declarations ----
    signal SRDI      : std_logic;
    signal SWRI      : std_logic;
    signal SDISPDO   : std_logic_vector(7 downto 0);

begin

    --------------------------------------------------------------------
    -- RDO driver
    --------------------------------------------------------------------
    rdo_drv:
    --------------------------------------------------------------------
        RDO <= (not DISP_RD) and not C51_RD;

        
    --------------------------------------------------------------------
    -- RAMWR driver
    --------------------------------------------------------------------
    ramwr_drv:
    --------------------------------------------------------------------
        RAMWR <= SWRI;

        
    --------------------------------------------------------------------
    -- RAMWRP driver
    --------------------------------------------------------------------
    ramwrp_drv:
    --------------------------------------------------------------------
        RAMWRP <= SWRI;

        
    --------------------------------------------------------------------
    -- Address mux
    --------------------------------------------------------------------
    addres_mux:
    --------------------------------------------------------------------
        with DISP_RD select
          ADDRESSO <= C51_ADDRESS   when '0',
                      DISP_ADDRESS  when others;

                
    --------------------------------------------------------------------
    -- Internal read signal
    --------------------------------------------------------------------
    ird_proc:
    --------------------------------------------------------------------
        SRDI <= DISP_RD or not C51_RD;

        
    --------------------------------------------------------------------
    -- Internal write signal
    --------------------------------------------------------------------
    iwr_proc:
    --------------------------------------------------------------------
        SWRI <= DISP_RD or not C51_WR;

        
    --------------------------------------------------------------------
    -- tristate buffer for C51 data
    --------------------------------------------------------------------
    c51datao_tbuf:
    --------------------------------------------------------------------
        with SRDI select
          C51_DATAO <= SDISPDO          when '0',
                       (others => 'Z')  when others;

                
    --------------------------------------------------------------------
    -- VGA data driver
    --------------------------------------------------------------------
    dipdatao_drv:
    --------------------------------------------------------------------
        DISP_DATAO <= SDISPDO;


    --------------------------------------------------------------------
    -- tristate buffer for RAM data io
    --------------------------------------------------------------------
    ramdataio_tbuf:
    --------------------------------------------------------------------
        with SWRI select
          RAM_DATAIO <= C51_DATAI        when '0',
                        (others => 'Z')  when others;

        
    --------------------------------------------------------------------
    -- internal data bus
    --------------------------------------------------------------------
    iramdata_proc:
    --------------------------------------------------------------------
        SDISPDO <= RAM_DATAIO;


end RAM_Controll_Arch;
